/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
CSkeleton cskel;
/******************************************************************************/
void InitPre()
{
   App.name="Animation Manual Editing";
   App.flag=APP_MS_EXCLUSIVE;
   PakAdd("../data/engine.pak");
}
/******************************************************************************/
Bool Init()
{
   Cam.dist=2;
   Cam.yaw =PI;

   cskel.create("../data/obj/chr/skeleton/0.skel",1.7);
   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.1,10,CAMH_ROT|CAMH_ZOOM);

   // set animations
   {   
      cskel.clear().animate("../data/anim/walk.anim",Tm.time()); // set default walking animation

      Orient &head=cskel.getBoneOrn("head");          // get head bone orientation
      head*=Matrix3().setRotateZ(Sin(Tm.time()*1.5)); // rotate head orientation according to time

      cskel.updateMatrix(MatrixIdentity) // update all matrixes
           .updateVelocities();          // update all bone velocities
   }

   return true;
}
/******************************************************************************/
void Draw()
{
   D.clear(WHITE);
   LightDir(1,Vec(0,0,-1)).set();

   // draw
   Meshs("../data/obj/chr/skeleton/0.mesh")->draw(cskel);
}
/******************************************************************************/
